# <font color=Black>Spartan-NFT-721</font>


<br/>

## <font color=Black>Function Introduction</font>
---

The Spartan-NFT-721 proxy contract is used to provide a complete set of APIs corresponding to ERC-721 methods. The interfaces include functions like Spartan-NFT mint, authorization, query authorization, transfer and destruction. The purpose of this set of contracts is to allow end-users to directly create and manage ERC721 NFTs under the governance of BSN Foundation. 


**Smart contract address:**

Spartan-I Chain (Powered by NC Ethereum): `0xD1A6C2dbCdbafbF0eCD033B38B83DbE0904caA4b`

Spartan-II Chain (Powered by NC Cosmos): `0x8fC9EC239fe077ce57a5C5D825e47Ffc2979Fbf8`

Spartan-III Chain (Powered by NC PolygonEdge): `0x55aa4279ec99E3952803b791b869B8911761f02A`

**Example:** https://github.com/BSN-Spartan/NFT.git


<br/>

## <font color=Black>API Definition</font>
---


### <font color=Black>Mint</font>


Users can mint NFTs by calling this interface.

- **Input parameters:** receiver address, NFT name, NFT symbol, uri;

- **Output parameters:** none;

- **Function definition:** mint (address to, string memory name, string memory symbol, string memory tokenURI);

- **Event parameters:** 0x0 address (null address), receiver address, NFT token ID;

- **Event definition:** Transfer (address (0), to, tokenID);

- **Example:** 

```groovy
   func TestMint(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tx, err := session.Mint(common.HexToAddress(owner), "sparton_nft", "sparton_nft", "sparton_nft")
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```
<br/>

### <font color=Black>Safe Mint</font>


Users can safe mint NFTs by calling this interface.

- **Input parameters:** receiver address, NFT name, NFT symbol, uri, attached args;

- **Output parameters:** none;

- **Function definition:** safeMint (address to, string memory name, string memory symbol, string memory tokenURI, bytes memory data);

- **Event parameters:** 0x0 address (null address), receiver address, NFT token ID;

- **Event definition:** Transfer (address (0), to, tokenID);

- **Example:** 

```groovy
   func TestSafeMint(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   data := []byte{0x1}
   tx, err := session.SafeMint(common.HexToAddress(owner), "sparton_nft", "sparton_nft", "sparton_nft", data)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>NFT Authorization</font>


An NFT owner can call this API to authorize the NFT, the sender of the transaction must be the NFT owner.

- **Input parameters:** authorizer’s wallet address, NFT token ID;

- **Output parameters:** none;

- **Function definition:** approve (address to, uint256 tokenID);

- **Event parameters:** owner’s wallet address, authorizer’s wallet address, NFT token ID;

- **Event definition:** Approval (operator, to, tokenID);

- **Example:** 

```groovy
   func TestApprove(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(1)
   tx, err := session.Approve(common.HexToAddress(account), tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>Query NFT Authorization</font>


Users can call this interface to query the NFT authorization.

- **Input parameters:** NFT token ID;

- **Output parameters:** authorizer’s wallet address;

- **Function definition:** getApproved (uint256 tokenID) view returns (address);

- **Example:** 


```groovy
   func TestGetApproved(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(1)
   tx, err := session.GetApproved(tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("Account Address: %s", tx.String()))
}
```

<br/>

### <font color=Black>Wallet Authorization</font>


An NFT owner can call this interface to authorize the wallet address, the sender of the transaction must be the NFT owner.

- **Input parameters:** authorizer’s wallet address, authorization ID;

- **Output parameters:** none;

- **Function definition:** setApprovalForAll (address operator, bool approved);

- **Event parameters:** owner’s wallet address, authorizer’s wallet address, authorization ID;

- **Event definition:** ApprovalForAll (owner, operator, approved);

- **Example:**

```groovy
   func TestSetApprovalForAll(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tx, err := session.SetApprovalForAll(common.HexToAddress(account), true)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>Verify Wallet Authorization</font>


Users can call this interface to verify the wallet authorization.

- **Input parameters:** owner’s wallet address, authorizer’s wallet address;

- **Output parameters:** Boolean value;

- **Function definition:** isApprovedForAll (address owner, address operator) view returns (bool);

- **Example:** 

```groovy
   func TestIsApprovedForAll(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tx, err := session.IsApprovedForAll(common.HexToAddress(owner), common.HexToAddress(account))
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("Is ApprovedForAll:%t", tx))
}
```

<br/>

### <font color=Black>Safe Transfer</font>


An NFT owner or authorized wallet address can call this interface to safe transfer the NFT.

- **Input parameters:** owner’s wallet address, receiver address, NFT token ID, attached args;

- **Output parameters:** none;

- **Function definition:** safeTransferFrom (address from, address to, uint256 tokenID, bytes memory data);

- **Event parameters:** owner’s wallet address, receiver address, NFT token ID;

- **Event definition:** Transfer (from, to, tokenID);

- **Example:** 

```groovy
   func TestSafeTransferFrom(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   data := []byte{0x1}
   tokenId := new(big.Int).SetUint64(1)
   tx, err := session.SafeTransferFrom(common.HexToAddress(owner), common.HexToAddress(account), tokenId, data)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>Transfer</font>


An NFT owner or authorized wallet address can call this interface to transfer the NFT.

- **Input parameters:** owner’s wallet address, receiver address, NFT token ID;

- **Output parameters:** none;

- **Function definition:** transferFrom (address from, address to, uint256 tokenID);

- **Event parameters:** owner’s wallet address, receiver address, NFT token ID;

- **Event definition:** Transfer (from, to, tokenID);

- **Example:** 

```groovy
   func TestTransferFrom(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(2)
   tx, err := session.TransferFrom(common.HexToAddress(owner), common.HexToAddress(account), tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>NFT Destruction</font>


An NFT owner or authorized wallet address can call this interface to destroy the NFT. 

- **Input parameters:** NFT token ID;

- **Output parameters:** none;

- **Function definition:** burn (uint256 tokenID);

- **Event parameters:** owner’s wallet address, 0x0 address (null address), NFT token ID;

- **Event definition:** Transfer (owner, address (0), tokenID);

- **Example:** 


```groovy
   func TestBurn(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(1)
   tx, err := session.Burn(tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tx Hash: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>Query Quantity</font>


Users can call this interface to query the quantity of the NFTs owned by this wallet address. 

- **Input parameters:** owner’s wallet address;

- **Output parameters:** number of NFTs;

- **Function definition:** balanceOf (address owner) view returns (uint256);

- **Example:** 


```groovy
   func TestBalanceOf(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tx, err := session.BalanceOf(common.HexToAddress(owner))
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("nft amount: %s", tx))
}
```

<br/>

### <font color=Black>Query NFT Owner</font>


Users can call this interface to query the owner of the NFT.

- **Input parameters:** NFT token ID;

- **Output parameters:** owner’s wallet address;

- **Function definition:** ownerOf (uint256 tokenID) view returns (address);

- **Example:** 

```groovy
   func TestOwnerOf(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(2)
   tx, err := session.OwnerOf(tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("Owner address: %s", tx.Hash().String()))
}
```

<br/>

### <font color=Black>Query NFT Name</font>


Users can call this interface to query the NFT name.

- **Input parameters:** NFT token ID;

- **Output parameters:** NFT name;

- **Function definition:** tokenName (uint256 tokenID) view returns (string memory);

- **Example:**


```groovy
   ffunc TestTokenName(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(2)
   tx, err := session.TokenName(tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("NFT name: %s", tx))
}
```

<br/>

### <font color=Black>Query NFT Symbol</font>

 
Users can call this interface to query the NFT symbol.

- **Input parameters:** NFT token ID;

- **Output parameters:** NFT symbol;

- **Function definition:** tokenSymbol (uint256 tokenID) view returns (string memory);

- **Example: **


```groovy
   func TestTokenSymbol(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(2)
   tx, err := session.TokenSymbol(tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("NFT symbol: %s", tx))
}
```

<br/>

### <font color=Black>Query NFT URI</font>


Users can call this interface to query the NFT URI.

- **Input parameters:** NFT token ID;

- **Output parameters:** NFT URI;

- **Function definition:** tokenURI (uint256 tokenID) view returns (string memory);

- **Example:**

```groovy
   func TestTokenURI(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tokenId := new(big.Int).SetUint64(2)
   tx, err := session.TokenURI(tokenId)
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("NFT URI: %s", tx))
}
```

<br/>

### <font color=Black>Query Latest Token ID</font>


Users can call this interface to query the latest NFT token ID.

- **Input parameters:** none;

- **Output parameters:** latest NFT token ID;

- **Function definition:** getLatestTokenID() view returns (uint256);

- **Example:** 

```groovy
   func TestGetLatestTokenID(t *testing.T) {
   cli := server.NewETHClientByURL(t, url, key)
   session, err := e.NewERC721Session(cli, common.HexToAddress(Address))
   if err != nil {
      t.Fatal(err)
   }
   tx, err := session.GetLatestTokenID()
   if err != nil {
      t.Fatal(err)
   }
   fmt.Println(fmt.Sprintf("tokenId: %s", tx))
}
```



<br/>
<br/>
<br/>